def cache(func):
    _cache = {}
    def inner(*args):
        key = (func.__name__,) + args
        if not key in _cache:
            _cache[key] = func(*args)
        return _cache[key]
    return inner        

@cache
def fibonacci(n):
    if n == 0:
        return 0
    if n == 1:
        return 1
    return fibonacci(n - 1) + fibonacci(n - 2)

print fibonacci(30)
