# -*- coding: iso-8859-1 -*-
## $Id: customisation.tex 93 2006-12-09 15:03:21Z gael.le-mignot $

## Copyright (C) 2006 Pilot Systems
## See COPYING and README for copying information

class FiboIterator(object):
    """
    A Fibonacci iterator
    """
    def __init__(self, fibo):
        """
        Constructor
        """
        self.v1 = fibo.f0
        self.v2 = fibo.f1
        self.left = fibo.maxval

    def next(self):
        """
        Get next value
        """
        if self.left is not None:
            if not self.left:
                raise StopIteration
            self.left -= 1
            
        val = self.v1 + self.v2
        self.v1 = self.v2
        self.v2 = val
        return val

class Fibonacci(object):
    """
    A general fibonacci class
    """
    def __init__(self, f0 = 0, f1 = 1, maxval = None):
        """
        Constructor
        """
        self.maxval = maxval
        self.f0 = f0
        self.f1 = f1

    def __getitem__(self, key):
        """
        Get a value
        """
        i = iter(self)
        for k in range(key):
            val = i.next()
        return val

    def __iter__(self):
        """
        Create an iterator
        """
        return FiboIterator(self)
