# -*- coding: iso-8859-1 -*-
## $Id: customisation.tex 93 2006-12-09 15:03:21Z gael.le-mignot $

## Copyright (C) 2006 Pilot Systems
## See COPYING and README for copying information

class Fibonacci(object):
    """
    A general fibonacci class
    """
    def __init__(self, f0 = 0, f1 = 1, maxval = None):
        """
        Constructor
        """
        self.maxval = maxval
        self.f0 = f0
        self.f1 = f1

    def __getitem__(self, key):
        """
        Get a value
        """
        i = iter(self)
        for k in range(key):
            val = i.next()
        return val

    def __iter__(self):
        """
        Create an iterator, through a generator
        """
        v1 = self.f0
        v2 = self.f1
        left = self.maxval

        while True:
            if left is not None:
                if not left:
                    return
                left -= 1

            val = v1 + v2
            v1 = v2
            v2 = val
            yield val
            
            
        
