# -*- coding: iso-8859-1 -*-
## $Id: customisation.tex 93 2006-12-09 15:03:21Z gael.le-mignot $

## Copyright (C) 2006 Pilot Systems
## See COPYING and README for copying information

import math

class Circle(object):
    """
    A smart circle
    """
    def __init__(self):
        """
        Constructor
        """
        self._radius = 0
        self._area = 0

    def get_radius(self):
        """
        Get radius
        """
        return self._radius

    def set_radius(self, radius):
        """
        Set radius
        """
        self._radius = radius
        self._area = math.pi * radius * radius

    def get_area(self):
        """
        Get area
        """
        return self._area

    def set_area(self, area):
        """
        Set area
        """
        self._area = area
        self._radius = math.sqrt(area / math.pi)

    radius = property(get_radius, set_radius)
    area = property(get_area, set_area)
    
