# -*- coding: iso-8859-1 -*-
## $Id: customisation.tex 93 2006-12-09 15:03:21Z gael.le-mignot $

## Copyright (C) 2006 Pilot Systems
## See COPYING and README for copying information

import time

def verbose(timefmt = None):
    """
    This is the toplevel function, that returns a decorator
    """
    def print_time():
        """
        Print time if asked for
        """
        if timefmt:
            print "[", time.strftime(timefmt), "]", 
    
    def decorator(func):
        """
        This is the second level function, that returns a decorated function
        """
        def inner(*args, **kwargs):
            """
            This is the inner function, returned as the decorated function
            """
            print_time()
            print " >", 
            print func.__name__, args, kwargs
            try:
                return func(*args, **kwargs)
            finally:
                print_time()
                print " <", 
                print func.__name__

        return inner

    return decorator
                

class Kangourou(object):
    """
    Un kangourou
    """
    color = "roux"

    @verbose()
    def __init__(self, name = "Sansnom"):
        """
        Constructor
        """
        self.name = name
        self.nb = 0

    @verbose("%H:%M:%S")
    def jump(self, nb = 1):
        """
        Sauter
        """
        for i in range(nb):
            self.nb += 1
            print "%s, un kangourou %s, saute (%d)" % (self.name, self.color, self.nb)

class KangourouBleu(Kangourou):
    """
    Un kangourou mutant
    """
    color = "bleu"

class BebeKangourou(Kangourou):
    """
    Un bb kangourou
    """
    @verbose("%H:%M:%S")
    def jump(self, nb = 1):
        """
        Sauter, enfin, comme on peut
        """
        for i in range(nb):
            if self.nb < 3:
                Kangourou.jump(self)
            else:
                raise RuntimeError, "%s est fatigu" % (self.name)
        
