# -*- coding: iso-8859-1 -*-
## $Id: customisation.tex 93 2006-12-09 15:03:21Z gael.le-mignot $

## Copyright (C) 2006 Pilot Systems
## See COPYING and README for copying information

class Logging(object):
    """
    Proxyfy any object into a verbose version
    """
    def __init__(self, obj):
        """
        Constructor
        """
        object.__setattr__(self, "obj", obj) # self.obj = obj

    def _proxy(self, func):
        """
        Proxyfy a function
        """
        def proxyfied(*args, **kwargs):
            print "-> %s," % func.__name__, args, kwargs
            try:
                return func(*args, **kwargs)
            finally:
                print "<- %s" % func.__name__
        return proxyfied

    def __getattr__(self, key):
        """
        Get a wrapped version of given function/attribute
        """
        value = getattr(self.obj, key)
        if callable(value):
            return self._proxy(value)
        else:
            return value

    def __setattr__(self, key, value):
        """
        Perform a setattr on the target
        """
        return setattr(self.obj, key, value)

    def __delattr__(self, key):
        """
        Perform a delattr on the target
        """
        return delattr(self.obj, key)
